#include "datamodel.h"
#include <QDebug>
#include <QSqlError>
#include <QSqlField>
#include <QSqlQuery>
#include <QSqlRecord>

DataModel::DataModel(QObject* parent, QSqlDatabase db)
    : QSqlTableModel(parent, db)
{
}

QHash<int, QByteArray> DataModel::roleNames() const
{
    QHash<int, QByteArray> roleNames;
    for (int i = 0; i < columnCount(); i++) {
        roleNames[Qt::UserRole + i + 1] = QVariant(headerData(i, Qt::Horizontal).toString()).toByteArray();
    }
    return roleNames;
}

QVariant DataModel::data(const QModelIndex& item, int role) const
{
    if (item.row() >= rowCount()) {
        return QVariant();
    }

    if (role < Qt::UserRole) {
        return QSqlTableModel::data(item, role);
    } else {
        return QSqlTableModel::data(this->index(item.row(), role - Qt::UserRole - 1), Qt::DisplayRole);
    }
}

QVariant DataModel::roleFromRow(int row, QString roleName)
{
    QSqlRecord rec = QSqlTableModel::record(row);
    return rec.value(roleName);
}

void DataModel::addRow(int row, QString newData)
{
    QStringList data = newData.split(";", QString::KeepEmptyParts);
    QSqlRecord newRecord = record();
    if (row == -1)
        newRecord.setGenerated(QStringLiteral("id"), true);
    else
        newRecord = record(row);
    newRecord.setValue(QStringLiteral("firstName"), data.at(0));
    newRecord.setValue(QStringLiteral("lastName"), data.at(1));
    newRecord.setValue(QStringLiteral("dob"), data.at(2));
    newRecord.setValue(QStringLiteral("address"), data.at(3));
    newRecord.setValue(QStringLiteral("city"), data.at(4));
    newRecord.setValue(QStringLiteral("state"), data.at(5));
    newRecord.setValue(QStringLiteral("zipCode"), data.at(6));
    newRecord.setValue(QStringLiteral("comments"), data.at(7));
    newRecord.setValue(QStringLiteral("weightData"), data.at(8));
    beginInsertRows(QModelIndex(), row, row + 1);

    if (row == -1)
        insertRecord(row, newRecord);
    else
        setRecord(row, newRecord);

    submitAll();
    endInsertRows();
    select();
}

void DataModel::removeRow(int row)
{
    beginRemoveRows(QModelIndex(), row, row - 1);
    QSqlTableModel::removeRows(row, 1, QModelIndex());
    submitAll();
    endRemoveRows();
    select();
}
